//
//  WXKScheduleFilter.m
//  SyncCalendar
//
//  Created by FUJIDANA on 06/09/17.
//  Copyright 2006 FUJIDANA. All rights reserved.
//

#import "WXKScheduleFilter.h"

static NSString *kAppleCalendarSchemaEventEntityName = @"com.apple.calendars.Event";

@implementation WXKScheduleFilter

#pragma mark init and dealloc

- (id)initWithRangeOfDateFrom:(NSDate *)fromDate to:(NSDate *)toDate
{
	self = [super init];
	if (self) {
		_fromDate = [fromDate copy];
		_toDate   = [toDate copy];
	}
	return self;
}

- (void)dealloc
{
	[_fromDate release];
	[_toDate release];
	
	[super dealloc];
}

#pragma mark Accessor methods
- (NSDate *)fromDate
{
	return _fromDate;
}

- (NSDate *)toDate
{
	return _toDate;
}

#pragma mark NSCoding

- (id)initWithCoder:(NSCoder *)coder
{
	self = [super init];
	if (self != nil) {
		_fromDate = [[coder decodeObjectForKey:@"fromDate"] retain];
		_toDate   = [[coder decodeObjectForKey:@"toDate"] retain];
	}
	return self;
}

- (void)encodeWithCoder:(NSCoder *)coder
{
	[coder encodeObject:_fromDate forKey:@"fromDate"];
	[coder encodeObject:_toDate   forKey:@"toDate"];
}

#pragma mark ISyncFiltering

- (BOOL)isEqual:(id)anotherFilter
{
	return ([anotherFilter isMemberOfClass:[self class]] && 
			[_fromDate isEqualToDate:[anotherFilter fromDate]] &&
			[_toDate isEqualToDate:[anotherFilter toDate]]);
}

- (NSArray *)supportedEntityNames
{
	return [NSArray arrayWithObject:kAppleCalendarSchemaEventEntityName];
}

- (BOOL)shouldApplyRecord:(NSDictionary *)record withRecordIdentifier:(NSString *)recordIdentifier
{
	NSString *entityName = [record objectForKey:ISyncRecordEntityNameKey];
	
	if ([entityName isEqualToString:kAppleCalendarSchemaEventEntityName]) {
		NSDate *startDate = [record objectForKey:@"start date"];
		NSDate *endDate   = [record objectForKey:@"end date"];
		
		if ([startDate timeIntervalSinceDate:[self fromDate]] > 0 && 
			[endDate   timeIntervalSinceDate:[self toDate]]   < 0) {
			return YES;
		} else {
			return NO;
		}
	}
	return YES;
}

@end
